<?PHP if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
* @package direct-as-a-service
* @subpackage models
* @filesource
*/

/**
* @package direct-as-a-service
* @subpackage models
*/
class FacilityModel extends CI_Model {
	
    function __construct() {
        parent::__construct();
		$this->load->database();
    }
    
    /*
     * get all facility data by facility id
     */
    public function get_facility($id){
    	return $this->db->query('SELECT * FROM facility WHERE id = '. $this->db->escape($id));
    }
    
    /*
     * get the list of facilities
     */
    public function get_facilities($is_active){
    	if($is_active == null or $is_active == "0") {
    		return $this->db->query('SELECT * FROM facility ORDER BY LOWER(name)');
    	}    
    	else {
    		return $this->db->query('SELECT * FROM facility where active = ' . $is_active . ' ORDER BY LOWER(name)');
    	}
    }
    /*
     * get number of pages
     */
    public function get_facilities_by_page_number($start, $size){
    	return $this->db->query('SELECT * FROM (select *, ROW_NUMBER() over (order by LOWER(name)) as row FROM facility) a where row >= ' . $this->db->escape($start) . ' and row < ' . $this->db->escape($size+$start));
    }
	
    /*
     * get the first load facilities
     */
	
	function get_first_facilities($size)//get response when no filters for first page
	{
    	return $this->db->query('SELECT * FROM (SELECT F.id, F.[name], ISNULL((SELECT COUNT(is_group) from [mail].[dbo].[mailboxes] where facility_id = F.id AND is_group != 0 GROUP BY facility_id),0) as Number_in_group, ISNULL((SELECT COUNT(is_group) from [mail].[dbo].[mailboxes] where facility_id = F.id AND is_group = 0 GROUP BY facility_id),0) as Number_of_users, ISNULL(sum(ms.sent), 0) AS Number_of_sent, ISNULL(sum(ms.seen), 0) AS Number_of_seen, COUNT(ms.id) as Total_messages, ROW_NUMBER() over (ORDER BY LOWER(F.[name]) ASC) as row FROM [api].[dbo].[facility] F left join [mail].[dbo].[mailboxes] M ON F.id = M.facility_id left join [mail].[dbo].[messages] MS ON MS.mailbox_id = M.id GROUP BY F.id, F.name, F.id) A   WHERE row >=1 and row <='.$this->db->escape($size));
	}
	
	/*
     * get the list of facilities size
     */
	 
	public function get_facility_list_size()//get size of entire list
	{
		return $this->db->query('select COUNT(*) as count from facility');
	}
	
	/*
     * get the list of facilities reports
     */
	 
	public function get_facility_list_size_reports()//get size of entire for reports
	{
		return $this->db->query('SELECT count(*) as count FROM [api].[dbo].[facility]');
	}
	
	/*
     * get the list of facilities and where 
     */
	 
	public function get_facility_list_size_reports_sql($sql)//get size of entire for reports
	{
		return $this->db->query('SELECT count(distinct F.id) as count ' .
								'FROM [api].[dbo].[facility] F left join [mail].[dbo].[mailboxes] M ' .
								'ON F.id = M.facility_id left join [mail].[dbo].[messages] MS ' .
								'ON MS.mailbox_id = M.id WHERE ' . $sql);
		
	}
	
	/*
     * get the list of facilities and different orders
     */
	
	function get_request_filter_facility_order($sql,$order,$start,$size)//get response with filters
	{
		if ($order == 'name DESC,id DESC' || $order == 'Name DESC,id DESC'){
			$order = 'DESC';
		}
		else{
			$order = 'ASC';
		}
		$sql= str_replace("(id","(F.id",$sql);//needed because both tables have the same column name
		return $this->db->query('SELECT * FROM (SELECT F.id, F.[name], ISNULL((SELECT COUNT(is_group) from [mail].[dbo].[mailboxes] where facility_id = F.id AND is_group != 0 GROUP BY facility_id),0) as Number_in_group, ISNULL((SELECT COUNT(is_group) from [mail].[dbo].[mailboxes] where facility_id = F.id AND is_group = 0 GROUP BY facility_id),0) as Number_of_users, ISNULL(sum(ms.sent), 0) AS Number_of_sent, ISNULL(sum(ms.seen), 0) AS Number_of_seen, COUNT(ms.id) as Total_messages, ROW_NUMBER() over (ORDER BY LOWER(F.[name]) '.$order.') as row FROM [api].[dbo].[facility] F left join [mail].[dbo].[mailboxes] M ON F.id = M.facility_id left join [mail].[dbo].[messages] MS ON MS.mailbox_id = M.id where '.$sql.' GROUP BY F.id, F.name, F.id) A   WHERE row >= '.$this->db->escape($start).' and row < '.$this->db->escape($size+$start));	
	}
	
	/*
     * get the list of facilities export
     */
	
	function get_request_filter_facility_order_export($sql,$order,$start,$size)//get response with filters
	{
		//Name
		if ($order == 'name DESC,id DESC' || $order == 'Name DESC,id DESC' ){
			$order = '(ORDER BY F.name DESC';
		}
		if ($order == 'name ASC,id ASC' || $order == 'Name DESC,id DESC'){
			$order = '(ORDER BY F.name ASC';
		}
		//Seen
		if ($order == 'received DESC,id DESC' ){
			$order = '(ORDER BY sum(ms.seen) DESC';
		}
		if ($order == 'received ASC,id ASC' ){
			$order = '(ORDER BY sum(ms.seen) ASC';
		}
		//Number_of_users
		if ($order == 'user DESC,id DESC' ){
			$order = '(ORDER BY (SELECT COUNT(is_group) from [mail].[dbo].[mailboxes] where facility_id = F.id AND is_group = 0 GROUP BY facility_id) DESC';
		}
		if ($order == 'user ASC,id ASC' ){
			$order = '(ORDER BY (SELECT COUNT(is_group) from [mail].[dbo].[mailboxes] where facility_id = F.id AND is_group = 0 GROUP BY facility_id) ASC';
		}
		//Sent
		if ($order == 'sent DESC,id DESC' ){
			$order = '(ORDER BY sum(ms.sent) DESC';
		}
		if ($order == 'sent ASC,id ASC' ){
			$order = '(ORDER BY sum(ms.sent) ASC';
		}
		//Total
		if ($order == 'total DESC,id DESC' ){
			$order = '(ORDER BY (sum(ms.seen) + sum(ms.sent)) DESC';
		}
		if ($order == 'total ASC,id ASC' ){
			$order = '(ORDER BY (sum(ms.seen) + sum(ms.sent)) ASC';
		}
		
		//Group
		if ($order == 'group DESC,id DESC' ){
			$order = '(ORDER BY (SELECT COUNT(is_group) from [mail].[dbo].[mailboxes] where facility_id = F.id AND is_group != 0 GROUP BY facility_id) DESC';
		}
		if ($order == 'group ASC,id ASC' ){
			$order = '(ORDER BY (SELECT COUNT(is_group) from [mail].[dbo].[mailboxes] where facility_id = F.id AND is_group != 0 GROUP BY facility_id) ASC';
		}
		$sql= str_replace("(id","(F.id",$sql);//needed because both tables have the same column name
		return $this->db->query('SELECt * FROM (SELECT F.id, F.[name],  ISNULL((SELECT COUNT(is_group) from [mail].[dbo].[mailboxes] where facility_id = F.id AND is_group = 0 GROUP BY facility_id),0) as Number_of_users, ISNULL((SELECT COUNT(is_group) from [mail].[dbo].[mailboxes] where facility_id = F.id AND is_group != 0 GROUP BY facility_id),0) as Number_in_group, ISNULL(sum(ms.sent), 0) AS Number_of_sent, ISNULL(sum(ms.seen), 0) AS Number_of_seen, COUNT(ms.id) as Total_messages, ROW_NUMBER() over '.$order.') as row FROM [api].[dbo].[facility] F left join [mail].[dbo].[mailboxes] M  ON F.id = M.facility_id left join [mail].[dbo].[messages] MS ON MS.mailbox_id = M.id where '.$sql.' GROUP BY F.id, F.name, F.id) A ');
	}
	
	/*
     * get the list of facilities
     */
	function get_request_filter_facility($sql,$order,$start,$size)
	{
		//Name
		if ($order == 'name DESC,id DESC' || $order == 'Name DESC,id DESC' ){
			$order = '(ORDER BY F.name DESC';
		}
		if ($order == 'name ASC,id ASC' || $order == 'Name DESC,id DESC'){
			$order = '(ORDER BY F.name ASC';
		}
		//Seen
		if ($order == 'received DESC,id DESC' ){
			$order = '(ORDER BY sum(ms.seen) DESC';
		}
		if ($order == 'received ASC,id ASC' ){
			$order = '(ORDER BY sum(ms.seen) ASC';
		}
		//Number_of_users
		if ($order == 'user DESC,id DESC' ){
			$order = '(ORDER BY (SELECT COUNT(is_group) from [mail].[dbo].[mailboxes] where facility_id = F.id AND is_group = 0 GROUP BY facility_id) DESC';
		}
		if ($order == 'user ASC,id ASC' ){
			$order = '(ORDER BY (SELECT COUNT(is_group) from [mail].[dbo].[mailboxes] where facility_id = F.id AND is_group = 0 GROUP BY facility_id) ASC';
		}
		//Sent
		if ($order == 'sent DESC,id DESC' ){
			$order = '(ORDER BY sum(ms.sent) DESC';
		}
		if ($order == 'sent ASC,id ASC' ){
			$order = '(ORDER BY sum(ms.sent) ASC';
		}
		//Total
		if ($order == 'total DESC,id DESC' ){
			$order = '(ORDER BY (sum(ms.seen) + sum(ms.sent)) DESC';
		}
		if ($order == 'total ASC,id ASC' ){
			$order = '(ORDER BY (sum(ms.seen) + sum(ms.sent)) ASC';
		}
		
		//Group
		if ($order == 'group DESC,id DESC' ){
			$order = '(ORDER BY (SELECT COUNT(is_group) from [mail].[dbo].[mailboxes] where facility_id = F.id AND is_group != 0 GROUP BY facility_id) DESC';
		}
		if ($order == 'group ASC,id ASC' ){
			$order = '(ORDER BY (SELECT COUNT(is_group) from [mail].[dbo].[mailboxes] where facility_id = F.id AND is_group != 0 GROUP BY facility_id) ASC';
		}
		return $this->db->query('SELECt * FROM (SELECT F.id, F.[name],  ISNULL((SELECT COUNT(is_group) from [mail].[dbo].[mailboxes] where facility_id = F.id AND is_group != 0 GROUP BY facility_id),0) as Number_in_group, ISNULL((SELECT COUNT(is_group) from [mail].[dbo].[mailboxes] where facility_id = F.id AND is_group = 0 GROUP BY facility_id),0) as Number_of_users, ISNULL(sum(ms.sent), 0) AS Number_of_sent, ISNULL(sum(ms.seen), 0) AS Number_of_seen, COUNT(ms.id) as Total_messages, ROW_NUMBER() over '.$order.') as row FROM [api].[dbo].[facility] F left join [mail].[dbo].[mailboxes] M  ON F.id = M.facility_id left join [mail].[dbo].[messages] MS ON MS.mailbox_id = M.id where '.$sql.' GROUP BY F.id, F.name, F.id) A   WHERE row >= '.$this->db->escape($start).' and row < '.$this->db->escape($size+$start));
	}
	
    /*
     * update the facility with passed values
     */
    public function save_facility($id, $name, $active) {	
		$user_id = $this->encrypt->decode($this->session->userdata('user_id'));
    	$permissions = $this->permissions->get_user_permissions($user_id);
    	$active_value = 0;
    	if($active == 'on') {
    		$active_value = 1;
    	}
    	
    	if($permissions['API']['admins']) {
			//$fac = $this->get_facility($id)->result(); //get app data from before change
			if($id != null) {
				return $this->db->query('UPDATE facility SET name = '.$this->db->escape($name).',active = '.$this->db->escape($active_value).' WHERE id = '.$this->db->escape($id));
			}
			else {
				return $this->db->query('INSERT INTO facility (name, active) VALUES (' . $this->db->escape($name). ',' . $this->db->escape($active_value) . ')');
			}
			
    	}
    	else {
    		return FALSE;
    	}
    }
    
    /*
     * Create a new facility, and give it permissions to access the Direct API
     */
    public function create_facility($name, $is_active){
		$this->load->model('usersmodel');
		//create facility in database
		$failed = FALSE;
    	$query = $this->db->query('INSERT INTO facility (name, public_key, private_key, url, description, poc_name, poc_email, poc_phone, app_request_id) VALUES ('.$this->db->escape($name).','.$this->db->escape($public).','.$this->db->escape($private).','.$this->db->escape($url).','.$this->db->escape($desc).','.$this->db->escape($poc_name).','.$this->db->escape($poc_email).','.$this->db->escape($poc_phone).','.$this->db->escape($request_id).')');
		//create facility in LDAP
		if($query) {
			$app_id = $this->get_facility_id_from_public($public);
			$ldap_conn = $this->prepare_ldap_conn();
			$ldap_bind = ldap_bind($ldap_conn, LDAP_ANON_ADMIN_USERNAME, LDAP_ANON_ADMIN_PASSWORD); //TO-DO: change bind to current user when permissions are set up
			if($ldap_bind) {
				$app_attributes = array(
					'objectClass' => array('organizationalUnit','top','uidObject'),
					'ou' => $name,
					'uid' => $app_id,
				);
				$requestor_username = $this->usersmodel->get_username_from_id($requestor);
				$admins_attributes = array(
					'objectClass' => 'groupOfNames',
					'cn' => $name.' Administrators',
					'member' => array(LDAP_ANON_ADMIN_USERNAME),
				);
				$users_attributes = array(
					'objectClass' => 'groupOfNames',
					'cn' => $name.' Authorized Users',
					'member' => array(LDAP_ANON_ADMIN_USERNAME),
				);
				if(isset($requestor_username) && strlen($requestor_username) > 0) {
					$admins_attributes['member'][1] = $this->usersmodel->get_dn_from_username($requestor_username); //put the requestor in the admins group
					$users_attributes['member'][1] = $this->usersmodel->get_dn_from_username($requestor_username); //put the requestor in the users group
				}
				
				$create_app_in_ldap = ldap_add($ldap_conn, $this->get_dn_from_app_id($app_id), $app_attributes);
				if($create_app_in_ldap) {
					$create_admins_group = ldap_add($ldap_conn, $this->get_admins_dn_from_app_id($app_id), $admins_attributes);
					$create_users_group = ldap_add($ldap_conn, $this->get_users_dn_from_app_id($app_id), $users_attributes);
					$give_api_access = ldap_mod_add($ldap_conn,LDAP_DIRECT_API_PERMISSIONS_GROUP,array('member' => $this->get_dn_from_app_id($app_id)));
					//when a problem comes along, you must whip it... and set this boolean to true
					if(!$create_admins_group || !$create_users_group || !$give_api_access) { $failed = TRUE; }
					else { return TRUE; } //if no problems, we succeeded
				}
				else { $failed = TRUE; }
			}
			//if we failed to create the facility in LDAP for any reason, we need to get rid of the bad data we have created
			if($failed) {
				//get rid of the app in LDAP
				$remove_api_access = ldap_mod_del($ldap_conn,LDAP_DIRECT_API_PERMISSIONS_GROUP,array('member' => $this->get_dn_from_app_id($app_id)));
				$delete_admins_group = ldap_delete($ldap_conn, $this->get_admins_dn_from_app_id($app_id));
				$delete_users_group = ldap_delete($ldap_conn, $this->get_users_dn_from_app_id($app_id));
				$delete_app_in_ldap = ldap_delete($ldap_conn, $this->get_dn_from_app_id($app_id));
				//get rid of the app in database
				$this->db->query('DELETE FROM facility WHERE id='.$this->db->escape($app_id));
			}
		}
		return FALSE;
    }
	
	
	/* -----------------------------*
	 *  PRIVATE FUNCTIONS           *
	 * -----------------------------*/
	 
	/* This function prepares a connection to LDAP using the configured constants for the facility
	  * and the LDAP options required for the connection. Returns FALSE on failure, LDAP connection resource
	  * on success.
	  */
	 private function prepare_ldap_conn() {
		$ldap_conn = ldap_connect(LDAP_HOSTNAME, LDAP_PORT);
		if(!ldap_set_option($ldap_conn, LDAP_OPT_PROTOCOL_VERSION, 3)) { return FALSE; } 
		if(!ldap_set_option($ldap_conn, LDAP_OPT_REFERRALS, 0)) { return FALSE; }
		return $ldap_conn;
	}
}
